//#define SMC 
#include "AS5600.h"
#include <AFMotor.h>

#include "TM1637Display.h"

#define CLK 22 //pins definitions for TM1637 and can be changed to other ports
#define DIO 24
TM1637Display  tm1637(CLK, DIO);
void setupTm637() {
  // put your setup code here, to run once:

  pinMode(A0,INPUT);
  pinMode(7,INPUT_PULLUP);
 
  //  tm1637.set();
  //  tm1637.init();
}

#define SW 26
#define DT 28
#define CK 30
#include <Servo.h>
Servo servo;
AF_DCMotor m1(1,MOTOR12_2KHZ); // Winde für Arm A
AF_DCMotor m2(2,MOTOR12_2KHZ); // Schneckenantrieb Arm B
AF_DCMotor m3(3,MOTOR12_2KHZ); // Drehteller
 
AF_DCMotor  mot[3]   = {  m1,m2,m3};

    volatile long enc_count = 0;
  
#define PUMP_A 44 // Ventil 25 rot      IN: Pump,   Out: Cyl Up
#define TANK_A 47 // Ventil 21 violett  IN: Cyl Up, Out: Open
#define PUMP_B 45 // Ventil 22 gruen    IN: Pump,   Out: Cyl Dn
#define TANK_B 46 // Ventil 24 schwarz  IN: Cyl Dn, Out: Open

#define VALVE_A 32
#define VALVE_B 33

/**
 * Ventil 25: A
 * Ventil 22: B
 */

void setupISR() {
  

  pinMode(50, INPUT);
  pinMode(51, INPUT);

  // Aktiviert Pin-Change Interrupt für Port B
  PCICR |= (1 << PCIE0);     // Enable PCINT0 interrupt (Port B)
  PCMSK0 |= (1 << PCINT3);   // Pin 50 (PB3)
  PCMSK0 |= (1 << PCINT2);   // Pin 51 (PB2)
}
volatile bool pin50Changed = false;
volatile bool pin51Changed = false;


ISR(PCINT0_vect) {
  // Statusvergleich von Port B
 static uint8_t tmp=0;
 static int8_t lookup_table[] = {0,-1,1,0,1,0,0,-1,-1,0,0,1,0,1,-1,0};
    static uint8_t enc_val = 0;
  static uint8_t lastPortB = PINB;
  uint8_t currentPortB = PINB;
// PB2 = 4, PB3=8

  if ((currentPortB ^ lastPortB) & (1 << PB3)) {
    pin50Changed = true; 
    tmp = ((currentPortB & (1 << PB2) ) | (currentPortB & (1 << PB3)))>> 2;
 //   Serial.print("A");
  }
 

  if ((currentPortB ^ lastPortB) & (1 << PB2)) {
    pin51Changed = true;
  //   Serial.print("B"); 
   tmp =   ((currentPortB & (1 << PB2) ) | (currentPortB & (1 << PB3)))>> 2;
  }
  
        
        enc_val = enc_val << 2;
        enc_val = enc_val | tmp;
     Serial.println(enc_val & 0b1111);
        enc_count = enc_count + lookup_table[enc_val & 0b1111];
  lastPortB = currentPortB;
}

    
#include <PID_v1_bc.h>

//int ulimit_l= 70;int ulimit_u=130;
//int ulimit_l= 0;int ulimit_u=255;

int ulimit_l= 0;int ulimit_u=30;

double input1Old, input, output , setpoint ;
//PID myPID = PID (&input, &output, &setpoint, .2, 4.5, 0.0, DIRECT);
//PID myPID = PID (&input, &output, &setpoint, 0.05, 4.5, 0.001, DIRECT);
PID myPID = PID (&input, &output, &setpoint, 8, .0, 0.0, DIRECT);

double  sinput, soutput , ssetpoint ;
//int l_slimit=15; int u_slimit=40; // Drehschieber

//int l_slimit=0; int u_slimit=40; 

//int l_slimit=0; int u_slimit=29; 
int l_slimit=-255; int u_slimit=255; 
/*
 * Mitte: (l_slimit + u_slimit) / 2
 * Swing: u_slimit -(l_slimit+u_slimit)/2 = (u_slimit-l_slmit) / 2
 */
//PID servoPID = PID (&sinput, &soutput, &ssetpoint, 0.05, .7, .0004, DIRECT); //0.55 20 0.0036
// gut  PID servoPID = PID (&sinput, &soutput, &ssetpoint, 0.07, 1, .0003, DIRECT); //0.55 20 0.0036
//double kp=0.18,ki=0.864,kd=0.0003;
//double kp=0.25,ki=0.4,kd=0.001;

//double kp=5.5,ki=6.5,kd=0.01;

//double kp=20,ki=25, kd=0.04; // 4 x VSONC

//double kp=50,ki=35, kd=0.28; // 2 x VSONC mit TANK: 200
double kp=25,ki=20, kd=0.020; // 2 x VSONC mit TANK: 200
//double kp=10,ki=30, kd=0.48; // 2 x VSONC mit TANK: 255

   PID servoPID = PID (&sinput, &soutput, &ssetpoint, kp,ki,kd, DIRECT); //0.55 20 0.0036
// PID servoPID = PID (&sinput, &soutput, &ssetpoint, 0.24, 3.84,0.000075, DIRECT); //0.55 20 0.0036


//PID servoPID = PID (&sinput, &soutput, &ssetpoint, 0.0020,1,0,.0000, DIRECT); // Quetsch-Servo
// Grenz: 0.13
#include "PID_AutoTune_v0.h"
PID_ATune aTune(&sinput, &soutput);
double aTuneStep=10, aTuneNoise=5, aTuneStartValue=20;
unsigned int aTuneLookBack=20;
byte ATuneModeRemember=2;
bool tuning=true;
  
/**
 * i2C-Weiche:
 */
#define TCAADDR 0x70
void tcascanner()
{
  Serial.println("\nTCAScanner ready!");
    
    for (uint8_t t=0; t<8; t++) {
      tcaselect(t);
      Serial.print("TCA Port #"); Serial.println(t);

      for (uint8_t addr = 0; addr<=127; addr++) {
        if (addr == TCAADDR) continue;

        Wire.beginTransmission(addr);
        if (!Wire.endTransmission()) {
          Serial.print("Found I2C 0x");  Serial.println(addr,HEX);
        }
      }
    }
    Serial.println("\ndone");
}

/**
 * i2C-Kanal einstellen
 */
void tcaselect(uint8_t i) {
  if (i > 7) return;
 
  Wire.beginTransmission(TCAADDR);
  Wire.write(1 << i);
  Wire.endTransmission();  
}

AS5600 encoder;

long time0;

/*
 * Sliding Mode Control Functions
 */

#ifdef SMC
/**
 * SMC
 */
double e;
double errint = 0.0;
 
double lambda = 2.0;
double sw=16.0;
double si=0.004;
double k=255; 


double sat(double s)
{
  double t = 2.0 / (1.0 + exp(-s/sw)) -1.0;
  return t ;
}

double calculate_SMC(double pos,double pos_prev)
{
  double err=ssetpoint - pos;
  errint += 0.1*err;
  double errdot = pos_prev - pos;
  double s = lambda * err+ errdot + si*errint;
  Serial.print(" ");
  Serial.println(err);
  double u = -k*sat(s);
  return -u;
}
#endif

void setup() {
  Serial.begin(115200);
    tcascanner();
  // put your setup code here, to run once:
 // pinMode(44,OUTPUT);
  //digitalWrite(44,LOW);
 //  pinMode(42,OUTPUT);
  //digitalWrite(42,LOW);
    /**
   * Aktiviere Greifer-Servo
   */
 // pinMode(9,OUTPUT);

 // servo.attach(9);
  
      myPID.SetMode(AUTOMATIC);   //set PID in Auto mode
    myPID.SetSampleTime(1);  // refresh rate of PID controller
    myPID.SetOutputLimits(ulimit_l, ulimit_u); // this is the MAX PWM value to move motor, here change in value reflect change in speed of motor.
    servoPID.SetMode(AUTOMATIC);   //set PID in Auto mode
    servoPID.SetSampleTime(1);  // refresh rate of PID controller
    servoPID.SetOutputLimits(-(u_slimit-l_slimit) / 2, (u_slimit-l_slimit) / 2); // drehventil this is the MAX PWM value to move motor, here change in value reflect change in speed of motor.
    //  servoPID.SetOutputLimits(0, 30); // quetschservo

   tcaselect(0);
   setpoint=encoder.getRawAngle(); // Startwert = Aktueller Wert
//setupISR();
  if(tuning)
  {
    tuning=false;
  //  changeAutoTune();
    tuning=true;
      pinMode(PUMP_A,OUTPUT);
  analogWrite(PUMP_A, 00);
  pinMode(PUMP_B,OUTPUT);
  analogWrite(PUMP_B, 00);
    pinMode(TANK_A,OUTPUT);
  analogWrite(TANK_A, 00);
    pinMode(TANK_B,OUTPUT);
  analogWrite(TANK_B, 00);
  }
  pinMode(VALVE_A,OUTPUT);
  pinMode(VALVE_B,OUTPUT);
  
 setupTm637();

  pinMode(CK, INPUT_PULLUP);
  pinMode(DT,INPUT_PULLUP);
  pinMode(SW,INPUT_PULLUP);
pinMode(2,INPUT);
}
#ifdef NORMAL
void vsonc_out(int val)
{
  if(val>0)
  {
            analogWrite(PUMP_B,val);
            digitalWrite(VALVE_B,HIGH);
            digitalWrite(VALVE_A,LOW);
        //analogWrite(TANK_A,0);
       //         analogWrite(TANK_B,val);
        //analogWrite(TANK_B,210);
        analogWrite(PUMP_A,0);
  }
  else
  {
      analogWrite(PUMP_B,
      00); // P
        //analogWrite(TANK_A,210); // T
        //analogWrite(TANK_A,-val); // T
        //analogWrite(TANK_B,0); // T
        analogWrite(PUMP_A,-val); // P
        digitalWrite(VALVE_B,LOW);
            digitalWrite(VALVE_A,HIGH);
  }
}
#else
void vsonc_out(int val)
{
  if(val>0)
  {
            analogWrite(PUMP_B,val);
            digitalWrite(VALVE_B,LOW);
            digitalWrite(VALVE_A,HIGH);
        //analogWrite(TANK_A,0);
       //         analogWrite(TANK_B,val);
        //analogWrite(TANK_B,210);
        analogWrite(PUMP_A,val);
  }
  else
  {
      analogWrite(PUMP_B,
      -val); // P
        //analogWrite(TANK_A,210); // T
        //analogWrite(TANK_A,-val); // T
        //analogWrite(TANK_B,0); // T
        analogWrite(PUMP_A,-val); // P
        digitalWrite(VALVE_B,HIGH);
            digitalWrite(VALVE_A,LOW);
  }
}
#endif
String cmd;
int state=0;
int dialstate=0;
long i=0;
float d=0.0, d_soll=510;
float vd,d_old=0.0;
float t,t_old=0.0;
#define MAXPEAKS 50
float peakIntervals[MAXPEAKS];
unsigned long lastPeakTime=0;

int u;
int control_on=1;
float avgPeriod=0.0;
int peakCount=0;
int rising=0;
int valve_speed=255;

void loop() {
  char buf[128];
  char * ptr;
  // put your main code here, to run repeatedly:
  float draw=0.0;
  tcaselect(0);  
  draw = 4096-encoder.getRawAngle();  //analogRead(A14);
  d= d*0.2 + 0.8* draw;
  if( d> d_old+1 && ! rising) rising=true;
  else if( d < d_old-1 && rising)
  {
    rising=false;
    unsigned long now=millis();
    /*
    if(lastPeakTime > 0 && peakCount<MAXPEAKS)
    {
      peakIntervals[peakCount++]=now -lastPeakTime;
    }
    */
    lastPeakTime=now;
    Serial.print("PEAK at ");
    Serial.print(now);
    Serial.print(" ms, Position: ");
    Serial.println(d);
  }
   // If enough peaks collected, compute average period
   /*
  if (peakCount == MAXPEAKS) {
    unsigned long sum = 0;
    for (int i = 0; i < MAXPEAKS; i++) {
      sum += peakIntervals[i];
    }
    avgPeriod = sum / (float)MAXPEAKS;
    Serial.print("AVG_PERIOD ");
    Serial.print(avgPeriod);
    Serial.println(" ms");
    peakCount = 0; // reset for next measurement
    delay(3000);
  }
  */
  
  t=millis();
  vd=(d-d_old)/(t-t_old);
  d_old=d; t_old=t;
  
  

  while (Serial.available()) { //Check if the serial data is available.
    delay(3);                  // a small delay
    char c = Serial.read();  // storing input data
    cmd += c;         // accumulate each of the characters in readString
  }
  if (cmd.length() >0 ) {
    cmd.toCharArray(buf, 100);
    
    if(cmd.startsWith("TO")) {
      d_soll = atof(buf+3);
      control_on=1;
    }
     if(cmd.startsWith("OPEN")) {
      int v;
      v = atoi(buf+4);
      Serial.println("OPEN");
  ;
     
        analogWrite(PUMP_A,250);
        analogWrite(TANK_A,250);
        analogWrite(PUMP_B,250);
        analogWrite(TANK_B,250);
  
    }
     if(cmd.startsWith("SPEED")) {
      int v;
      v = atoi(buf+5);
      Serial.print("SPEED ");
      Serial.println(v);
      valve_speed=v;
     }
#ifdef NORMAL
     if(cmd.startsWith("UP")) {
      int v;
      v = atoi(buf+4);
        Serial.println("UP");

        
        digitalWrite(VALVE_A,LOW);               
        analogWrite(PUMP_A,0);
        
        digitalWrite(VALVE_B,HIGH);
        analogWrite(PUMP_B,250);
        control_on=0;
     }
      if(cmd.startsWith("DN")) {
      int v;
      v = atoi(buf+4);
        Serial.println("DN");
        digitalWrite(VALVE_A,HIGH);               
        analogWrite(PUMP_A,250);
        
        digitalWrite(VALVE_B,LOW);
        analogWrite(PUMP_B,0);

        control_on=0;
      }
#else
 if(cmd.startsWith("UP")) {
      int v;
      v = atoi(buf+4);
        Serial.println("UP");

        
        digitalWrite(VALVE_A,LOW);               
        analogWrite(PUMP_A,250);
        
        digitalWrite(VALVE_B,HIGH);
        analogWrite(PUMP_B,250);
        control_on=0;
     }
      if(cmd.startsWith("DN")) {
      int v;
      v = atoi(buf+4);
        Serial.println("DN");
        digitalWrite(VALVE_A,HIGH);               
        analogWrite(PUMP_A,250);
        
        digitalWrite(VALVE_B,LOW);
        analogWrite(PUMP_B,250);

        control_on=0;
      }
 #endif
    if(cmd.startsWith("OFF")) {
      state=1-state;
        analogWrite(PUMP_A,0);
        analogWrite(TANK_A,0);
        analogWrite(PUMP_B,0);
        analogWrite(TANK_B,0);
            digitalWrite(VALVE_A,LOW);
                digitalWrite(VALVE_B,LOW);
         control_on=0;
      time0=millis();      
    }
     if(cmd.startsWith("S")) {
      ptr = strtok(buf+2, ",");
      int s =atoi(ptr);
      servo.write(s);
      control_on=0;
    //  delay(200);
    //  servo.write(95);
    }
    if(cmd.startsWith("A")) {
       if( atoi(buf+1) ==1)
       {
        digitalWrite(42,HIGH);
       }
       else
       {
        digitalWrite(42,LOW);
       }
      
    }
    if(cmd.startsWith("B")) {
      if( atoi(buf+1) ==1)
       {
        digitalWrite(44,HIGH);
       }
       else
       {
        digitalWrite(44,LOW);
       }
      
    }
    cmd="";
    }
/* // RC Control
  int val = pulseIn(2, HIGH);
  int mval=map(val,900,2000,2200,2600); 
  Serial.print(val); 
  d_soll=mval;
  Serial.print(" ");
  */
  //Serial.print(" T:");
 // Serial.print(millis() -time0);
  //Serial.print(", ");
 // Serial.print(enc_count);
 //   Serial.print(", ");
  //Serial.print(" SOLL:");
  Serial.print(d_soll); 
  input=d;
    
  setpoint=d_soll ;
  Serial.print(", ");
  //Serial.print("IST:"); 
  Serial.print(d); 
 

  sinput=d; //enc_count;
  ssetpoint = d_soll;
 #ifdef SMC
   soutput = calculate_SMC(d,d_old);
 #else
 tuning=false;
 if(tuning)
   {
    byte val = (aTune.Runtime());
    if (val!=0)
    {
      tuning = false;
    }
    if(!tuning)
    { //we're done, set the tuning parameters
      kp = aTune.GetKp();
      ki = aTune.GetKi();
      kd = aTune.GetKd();
      servoPID.SetTunings(kp,ki,kd);
      AutoTuneHelper(false);
    }
  }
  else
  {
    if(d_soll<2400) 
    {
      
       servoPID.SetTunings(16,ki,kd);
    }
     else
     {
       servoPID.SetTunings(40,ki,kd);
     }
    servoPID.Compute();
  }
 #endif

  if(!digitalRead(SW))
  {
      if(dialstate==0) dialstate=1;
      else if(dialstate==1) 
  {
    dialstate=0;
    d_soll=enc_count;
  }
  }
  else 

  if(dialstate==0)
    enc_count= (int) d;

  
  d_old=d;
     
  //Serial.print(" s:");
 
  /*
  if(d-d_soll>0 && abs(vd)<0.02)
       soutput =13;
     if(d-d_soll<0 && abs(vd)<0.02)
       soutput =26;   
       */

  //Serial.print(soutput);
 //soutput = (u_slimit +l_slimit) / 2 -soutput;
 //soutput = (u_slimit +l_slimit) / 2 +soutput; // Quetsch
 // Ausschalten
 //if(abs(d-d_soll) < 15)
 // soutput=17;

/* Timing von tm1637 verhundst PID-REgelung
if(dialstate==0)
{
//tm1637.displayNum((int) d);
tm1637.showNumberDec((int) d, false,4,0);
tm1637.setBrightness(0x0f,true); 
}
else
{
  //tm1637.displayNum((int) enc_count);
  tm1637.showNumberDecEx((int) enc_count,64,
  false,4,0);
  tm1637.setBrightness(1,true); 
}
*/
 Serial.print(" ");
 Serial.print(soutput);

if(control_on)
  //servo.write(soutput);
  {

  vsonc_out(soutput);
 
  }
  
  Serial.println();
}

void changeAutoTune()
{
 if(!tuning)
  {
    //Set the output to the desired starting frequency.
    output=aTuneStartValue;
    aTune.SetNoiseBand(aTuneNoise);
    aTune.SetOutputStep(aTuneStep);
    aTune.SetLookbackSec((int)aTuneLookBack);
    AutoTuneHelper(true);
    tuning = true;
  }
  else
  { //cancel autotune
    aTune.Cancel();
    tuning = false;
    AutoTuneHelper(false);
  }
}

void AutoTuneHelper(boolean start)
{
  if(start)
    ATuneModeRemember = myPID.GetMode();
  else
   servoPID.SetMode(ATuneModeRemember);
}

/**
 * PWM-Wert out für Motor i ausgeben
 */
void pwmOut(int i,int out) {            
    if (out > 0) {                  
      mot[i].run(FORWARD); mot[i].setSpeed(out); 
    }
    else {
      mot[i].run(BACKWARD); mot[i].setSpeed(abs(out)); 
    } 
}
